/* main.c */

#define IOWarriorSuiteID 'iWrr'

#include <Dialogs.h>
#include <Fonts.h>
#include <MacWindows.h>
#include <Menus.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <AEObjects.h> 

#include "main.h"
#include "AEAccessors.h"
#include "IOWarriorOS9Lib.h"

void Initialize(void);	/* function prototypes */
void EventLoop(void);
void MakeWindow(void);
void MakeMenu(void);
void DoEvent(EventRecord *event);
void DoMenuCommand(long menuResult);
void DoAboutBox(void);
void DrawWindow(WindowRef window);
static OSErr QuitAppleEventHandler(const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);

OSErr IOWarriorPresentHandler (const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);
OSErr IOWarriorWriteInterface0Handler (const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);
OSErr IOWarriorReadInterface0Handler (const AppleEvent *appleEvt, AppleEvent* reply, UInt32 refcon);
OSErr IOWarriorWriteInterface1Handler (const AppleEvent *appleEvt, AppleEvent* , UInt32 );
OSErr IOWarriorReadInterface1Handler (const AppleEvent *appleEvt, AppleEvent* , UInt32 );
OSErr IOWarriorReportCountHandler (const AppleEvent *, AppleEvent* reply, UInt32);

OSErr IOWarriorSetHandler (const AppleEvent *appleEvent, AppleEvent* reply, UInt32 refCon);
OSErr IOWarriorGetHandler (const AppleEvent *appleEvent, AppleEvent* reply, UInt32 refCon);

OSErr HandleSetData(const AEDesc *theObj, AEDesc *dataDesc);
OSErr HandleGetData(AEDesc *theObj, AEDesc *dataDesc);

OSErr AddResultToReply(AEDesc* result, AEDesc* reply, OSErr error);

void SetPinValueAtIndex (int pinIndex, int value);
int GetPinValueAtIndex (int pinIndex);

int bitOffsetForPinIndex (int inIndex);


// receiving and handling interface 1 reports
struct ReportListNodeStruct
{
	Ptr	reportData;
	struct ReportListNodeStruct* nextNode;
};

typedef struct ReportListNodeStruct ReportListNode;

void 			myReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 /* inRefcon */);
void 			InsertReportData (unsigned char* inData, UInt32 inReportLength);
int 			NumberOfReportsReceived ();
ReportListNode* ExtractFirstReport ();
void 			DisposeReportListNode (ReportListNode* inNode);



/* globals */

Boolean			gQuitFlag;
Boolean			gSaveReports = true;
ReportListNode*	gReceivedReports = NULL; // ptr to list of saved reports

int main()
{
	Initialize();
	MakeMenu();
        
    // Init the IOWarriorLibrary
    IOWarriorInit ();
    
    
    // Install report handler for receiving reports from interface 1
   	if (IOWarriorIsPresent ())
   	{
   		IOWarriorInstallReportHandlerInterface1 (myReportHandler, 0);
   	}
        
        
	EventLoop();

	return 0;
}
 
void Initialize()	/* Initialize some managers */
{
    OSErr	err;
    
    InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(NULL);
    InitCursor();
    AEObjectInit  ();

    err = AEInstallEventHandler( kCoreEventClass, kAEQuitApplication, NewAEEventHandlerUPP((AEEventHandlerProcPtr)QuitAppleEventHandler), 0, false );
    err = AEInstallEventHandler( IOWarriorSuiteID, 'iWPr', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorPresentHandler), 0, false );
   
   	err = AEInstallEventHandler( IOWarriorSuiteID, 'iWr0', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorWriteInterface0Handler), 0, false );
   	err = AEInstallEventHandler( IOWarriorSuiteID, 'iRd0', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorReadInterface0Handler), 0, false );
   	err = AEInstallEventHandler( IOWarriorSuiteID, 'iWr1', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorWriteInterface1Handler), 0, false );
    err = AEInstallEventHandler( IOWarriorSuiteID, 'iRd1', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorReadInterface1Handler), 0, false );
    
    err = AEInstallEventHandler( IOWarriorSuiteID, 'iWrc', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorReportCountHandler), 0, false );

    err = AEInstallEventHandler( 'core', 'getd', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorGetHandler), 0, false );
	err = AEInstallEventHandler( 'core', 'setd', NewAEEventHandlerUPP((AEEventHandlerProcPtr)IOWarriorSetHandler), 0, false );
	
	// Install custom AppleEvent accessor functions
	InstallAEAccessor ();


    if (err != noErr)
        ExitToShell();
}

static OSErr QuitAppleEventHandler( const AppleEvent *, AppleEvent* , UInt32  )
{
    gQuitFlag =  true;
    
    return noErr;
}

void EventLoop()
{
    Boolean	gotEvent;
    EventRecord	event;
        
    gQuitFlag = false;
	
    do
    {
        gotEvent = WaitNextEvent(everyEvent,&event,32767,nil);
        if (gotEvent)
            DoEvent(&event);
    } while (!gQuitFlag);
    
    ExitToShell();					
}

void MakeWindow()	/* Put up a window */
{

		
}

void MakeMenu()		/* Put up a menu */
{
    Handle	menuBar;
    MenuRef	menu;
    long	response;
    OSErr	err;
	
    menuBar = GetNewMBar(rMenuBar);	/* read menus into menu bar */
    if ( menuBar != nil )
    {
        SetMenuBar(menuBar);	/* install menus */
        // AppendResMenu(GetMenuHandle(mApple), 'DRVR');
        
        err = Gestalt(gestaltMenuMgrAttr, &response);
	if ((err == noErr) && (response & gestaltMenuMgrAquaLayoutMask))
        {
            menu = GetMenuHandle( mFile );
            DeleteMenuItem( menu, iQuit );
            DeleteMenuItem( menu, iQuitSeparator );
        }
        
        DrawMenuBar();
    }
    else
    	ExitToShell();
}

void DoEvent(EventRecord *event)
{
    short	part;
    Boolean	hit;
    char	key;
    Rect	tempRect;
    WindowRef	whichWindow;
        
    switch (event->what) 
    {
        case mouseDown:
            part = FindWindow(event->where, &whichWindow);
            switch (part)
            {
                case inMenuBar:  /* process a moused menu command */
                    DoMenuCommand(MenuSelect(event->where));
                    break;
                    
                case inSysWindow:
                    break;
                
                case inContent:
                    if (whichWindow != FrontWindow()) 
                        SelectWindow(whichWindow);
                    break;
                
                case inDrag:	/* pass screenBits.bounds */
                    //GetRegionBounds(GetGrayRgn(), &tempRect);
                    DragWindow(whichWindow, event->where, &tempRect);
                    break;
                    
                case inGrow:
                    break;
                    
                case inGoAway:
                    DisposeWindow(whichWindow);
                    ExitToShell();
                    break;
                    
                case inZoomIn:
                case inZoomOut:
                    hit = TrackBox(whichWindow, event->where, part);
                    if (hit) 
                    {
                        SetPort((whichWindow));   // window must be current port
                        EraseRect(GetWindowPortBounds(whichWindow, &tempRect));   // inval/erase because of ZoomWindow bug
                        ZoomWindow(whichWindow, part, true);
                        //InvalWindowRect(whichWindow, GetWindowPortBounds(whichWindow, &tempRect));	
                    }
                    break;
                }
        break;
		
                case keyDown:
		case autoKey:
                    key = event->message & charCodeMask;
                    if (event->modifiers & cmdKey)
                        if (event->what == keyDown)
                            DoMenuCommand(MenuKey(key));
		case activateEvt:	       /* if you needed to do something special */
                    break;
                    
                case updateEvt:
			DrawWindow((WindowRef) event->message);
			break;
                        
                case kHighLevelEvent:
			AEProcessAppleEvent( event );
			break;
		
                case diskEvt:
			break;
	}
}

void DoMenuCommand(long menuResult)
{
    short	menuID;		/* the resource ID of the selected menu */
    short	menuItem;	/* the item number of the selected menu */
	
    menuID = HiWord(menuResult);    /* use macros to get item & menu number */
    menuItem = LoWord(menuResult);
	
    switch (menuID) 
    {
        case mApple:
            switch (menuItem) 
            {
                case iAbout:
                    DoAboutBox();
                    break;
                    
                default:
                    break;
            }
            break;
        
        case mFile:
        {
        	case iQuit:
                    ExitToShell();
                    break;
            break;
        }
		
        case mEdit:
            break;
    }
    HiliteMenu(0);	/* unhighlight what MenuSelect (or MenuKey) hilited */
}

void DrawWindow(WindowRef window)
{
    Rect		tempRect;
    GrafPtr		curPort;
	
    GetPort(&curPort);
    SetPort(window);
    BeginUpdate(window);
    EraseRect(GetWindowPortBounds(window, &tempRect));
    DrawControls(window);
    DrawGrowIcon(window);
    EndUpdate(window);
    SetPort(curPort);
}

void DoAboutBox(void)
{
   (void) Alert(kAboutBox, nil);  // simple alert dialog box
}

OSErr IOWarriorPresentHandler (const AppleEvent *, AppleEvent* reply, UInt32)
{
	Boolean	result;
	
	result = IOWarriorIsPresent ();
	
	return  AEPutParamPtr (reply, keyDirectObject, typeBoolean, &result, sizeof (Boolean));
}

OSErr IOWarriorReportCountHandler (const AppleEvent *, AppleEvent* reply, UInt32)
{
	int	result;
	
	result = NumberOfReportsReceived ();
	
	return  AEPutParamPtr (reply, keyDirectObject, typeInteger, &result, sizeof (int));
}

OSErr IOWarriorWriteInterface0Handler (const AppleEvent *appleEvt, AppleEvent* , UInt32 )
{
	unsigned char		data[4];
    Size				theSize;
    DescType			theType;
    SInt32				temp;
    OSErr				err;
    
	AEGetParamPtr(appleEvt, 'prt0', typeInteger, &theType, &temp,
						sizeof(SInt32), &theSize);
	data[0] = temp;
	AEGetParamPtr(appleEvt, 'prt1', typeInteger, &theType, &temp,
						sizeof(SInt32), &theSize);
	data[1] = temp;
	AEGetParamPtr(appleEvt, 'prt2', typeInteger, &theType, &temp,
						sizeof(SInt32), &theSize);
	data[2] = temp;
	AEGetParamPtr(appleEvt, 'prt3', typeInteger, &theType, &temp,
						sizeof(SInt32), &theSize);
	data[3] = temp;
						
	err = IOWarriorWriteInterface0 (&data);
		
	return err;
		
}

OSErr IOWarriorWriteInterface1Handler (const AppleEvent *appleEvt, AppleEvent* , UInt32 )
{
	unsigned char	reportID;
	unsigned char	data[7];
	Size			theSize;
    DescType		theType;
    SInt32			temp;
	
	AEGetParamPtr(appleEvt, 'rpID', typeInteger, &theType, &temp,
						sizeof(SInt32), &theSize);
	
	reportID = temp;
	
	for (int i = 0; i < 7; i++)
	{
		AEKeyword paramKeyword = 'byt0';
		unsigned char* ptrToLastKeywordLetter = (unsigned char*) &paramKeyword + 3;
		
		*ptrToLastKeywordLetter = '0' + i;
		
		if (errAEDescNotFound == AEGetParamPtr(appleEvt, paramKeyword, typeInteger, &theType, &temp, sizeof(SInt32), &theSize))
		{
			// if the event parameter was not specified we are using default value 0
			data[i] = 0;
		}
		else
			data[i] = temp;
	}
	
	return IOWarriorWriteInterface1 (reportID, data);
}

OSErr IOWarriorReadInterface0Handler (const AppleEvent *, AppleEvent* reply , UInt32 )
{
	unsigned char		data[4];
	AEDescList	aeArray;
	AEDesc		portData;
	int			temp;
	OSErr		err;
		
	err = IOWarriorReadInterface0 (&data);
	if (err)
		return err;
	
	err = AECreateList (NULL, 0, false, &aeArray);
	for (int i = 0; i < 4; i++)
	{
		temp = data[i];
		err = AECreateDesc (typeInteger, &temp, sizeof (temp), &portData);
		err = AEPutDesc (&aeArray, i + 1, &portData);
		AEDisposeDesc (&portData);
	}
	
	err =  AEPutParamDesc (reply, keyDirectObject, &aeArray);
	AEDisposeDesc (&aeArray);
	
	return err;
}

OSErr IOWarriorReadInterface1Handler (const AppleEvent* /*appleEvt*/, AppleEvent* reply , UInt32 )
{
    SInt32			temp;
	OSErr			err = noErr;
	AEDescList		aeArray;
	AEDesc			portData;
	
	
	if (NumberOfReportsReceived ())
	{
		ReportListNode*	report;
		
		report = ExtractFirstReport ();	
		
		err = AECreateList (NULL, 0, false, &aeArray);
		for (int i = 0; i < GetPtrSize ( report->reportData) ; i++)
		{
			temp = report->reportData[i];
			err = AECreateDesc (typeInteger, &temp, sizeof (temp), &portData);
			err = AEPutDesc (&aeArray, i + 1, &portData);
			AEDisposeDesc (&portData);
		}
		err =  AEPutParamDesc (reply, keyDirectObject, &aeArray);
		AEDisposeDesc (&aeArray);
		DisposeReportListNode (report);
	}
	
	return err;
}

OSErr IOWarriorSetHandler (const AppleEvent *theAppleEvent, AppleEvent* , UInt32)
{
	AEDesc 	directObj = {typeNull, NULL},
			dataDesc = {typeNull, NULL};
	OSErr  	err;
			
		// pick up the direct object, which is the object whose data is to be set
	err = AEGetParamDesc(theAppleEvent,  keyDirectObject,
									typeWildCard, &directObj);
	if (noErr != err) goto done;
		
		// now the data to set it to - typeWildCard means get as is
		// e.g. this is the name of the font for text
	err = AEGetParamDesc(theAppleEvent, keyAEData, typeWildCard, &dataDesc);
	if (noErr != err)
		goto done;
	
		// missing any parameters?
	//err = GotRequiredParams(theAppleEvent);
	//if (noErr != err)
	//	goto done;
	
		// set the data
	err = HandleSetData(&directObj, &dataDesc);

done:			
	if (directObj.dataHandle)
		AEDisposeDesc(&directObj);
	if (dataDesc.dataHandle)
		AEDisposeDesc(&dataDesc);

	return(err);
}

OSErr HandleSetData(const AEDesc *theObj, AEDesc *dataDesc)
{
	//TextToken       theTextToken;
	Size            tokenSize;
	AEDesc          objTokenDesc = {typeNull, NULL},
					itemDesc = {typeNull, NULL},
					ignoreResult = {typeNull, NULL};
	long			index;
	DescType		returnedType;
	OSErr           err;

		//	Coerce theObj into a token which we can use - 
		//		 set the property or data for that token
	if (typeObjectSpecifier == theObj->descriptorType)
	{
		err = AEResolve(theObj, kAEIDoMinimum, &objTokenDesc);	
	}
	else	// Otherwise, just copy it
		err = AEDuplicateDesc(theObj, &objTokenDesc);

	if (noErr != err) goto done;
			
	switch (objTokenDesc.descriptorType)
	{
	
		case kPrivateTypePinProp:
		{
			PinPropToken 	pinProp;
			short			 newValue;
			
			GetRawDataFromDescriptor(&objTokenDesc,  (Ptr)&pinProp, sizeof(pinProp), &tokenSize);							
			if (pinProp.pinProperty == 'valu')
			{
				GetIntegerFromDescriptor (dataDesc, &newValue);
				SetPinValueAtIndex (pinProp.pinIndex - 1, newValue > 0);
			}
		}
		break;

		case typeAEList:				// If it's a list then do each item
			err = AECountItems(&objTokenDesc, &index);
			if (noErr != err) goto done;

			for (; index > 0; index--)
			{
				err = AEGetNthDesc(&objTokenDesc, index, typeWildCard, &returnedType, &itemDesc);

				if (noErr == err)		// Get property by calling this function again
					err = HandleSetData(&itemDesc, dataDesc);
				
				if (itemDesc.dataHandle)
					AEDisposeDesc(&itemDesc);
			}
			break;
			
		default:
			err = errAEWrongDataType;
	}

done:
	if (objTokenDesc.dataHandle)	
		AEDisposeDesc(&objTokenDesc);
	if (itemDesc.dataHandle)	
		AEDisposeDesc(&itemDesc);
	if (ignoreResult.dataHandle)
		AEDisposeDesc(&ignoreResult);

	return(err);
} // HandleSetData


OSErr IOWarriorGetHandler (const AppleEvent *theAppleEvent, AppleEvent* reply, UInt32 refCon)
{
	#pragma unused (refCon)

	AEDesc		directObj = {typeNull, NULL},
				result = {typeNull, NULL};
	Size		actualSize;
	DescType	returnedType;
	DescType	reqType;
	OSErr		reqTypeErr,
				err;
	
		// extract the direct object, which is the object
		// whose data is to be returned
	err = AEGetParamDesc(theAppleEvent, keyDirectObject, typeWildCard, &directObj);
	if (noErr != err) goto done;
		
		// now the get the type of data wanted - optional
	reqTypeErr = AEGetParamPtr(theAppleEvent, keyAERequestedType, typeType,
								&returnedType, (Ptr)&reqType, sizeof(reqType), &actualSize);
		
	//err = GotRequiredParams(theAppleEvent);
	if (noErr != err) goto done;
	
		// get the data
	err = HandleGetData(&directObj, &result);
		
	err = AddResultToReply(&result, reply, err);

done:				
	if (directObj.dataHandle)
		  AEDisposeDesc(&directObj);
	if (result.dataHandle)
		  AEDisposeDesc(&result);
		
	return(err);

}

// -----------------------------------------------------------------------
//	Name: 		HandleGetData
//	Purpose:	Coerces theObj into a token which we understand and
//				extracts the data requested in the token and puts it
//				into dataDesc.
// -----------------------------------------------------------------------

OSErr	HandleGetData(AEDesc *theObj, AEDesc *dataDesc)
{
	Size            tokenSize;
	AEDesc          objTokenDesc = {typeNull, NULL},
					itemDesc = {typeNull, NULL},
					resultDesc = {typeNull, NULL};
	long			index;
	DescType		returnedType;
	OSErr           err;

			//	Coerce theObj into a token which we can use - 
			//		this may involve converting a list of tokens to a list of property tokens
	if (typeObjectSpecifier == theObj->descriptorType)
		err = AEResolve(theObj, kAEIDoMinimum, &objTokenDesc);
	else	// Otherwise, just copy it
		err = AEDuplicateDesc(theObj, &objTokenDesc);
	
	if (noErr != err) goto done;
	
	switch (objTokenDesc.descriptorType)
	{
		case kPrivateTypePinProp:
		{
			PinPropToken 	pinProp;
			UInt32			myValue = 0;
			
			GetRawDataFromDescriptor(&objTokenDesc,  (Ptr)&pinProp, sizeof(pinProp), &tokenSize);							
			if (pinProp.pinProperty == 'valu')
			{
				myValue = GetPinValueAtIndex (pinProp.pinIndex - 1);
				
				err = AECreateDesc(typeInteger, (Ptr)&myValue,
								sizeof(myValue), dataDesc);
			}
		}
		break;
			
		case typeAEList:
			err = AECountItems(&objTokenDesc, &index);
			if (noErr != err) goto done;
	
			for (; index > 0; index--)
			{
				err = AEGetNthDesc(&objTokenDesc, index, typeWildCard, &returnedType, &itemDesc);
	
				if (noErr == err)		// Call this function recursively if necessary
					err = HandleGetData(&itemDesc, &resultDesc);
				
				if (noErr == err)		// Overwrite item in list with descriptor item
					err = AEPutDesc(&objTokenDesc, index, &resultDesc);
														// objTokenDesc is just a copy anyway.
				if (itemDesc.dataHandle)
					AEDisposeDesc(&itemDesc);
				if (resultDesc.dataHandle)
					AEDisposeDesc(&resultDesc);
			}
			
			err = AEDuplicateDesc(&objTokenDesc, dataDesc);		// Copy list into result
			break;
			
		default:	
			err = errAEWrongDataType;
	}

done:
	if (objTokenDesc.dataHandle)
		AEDisposeDesc(&objTokenDesc);
	
	return(err);
} // HandleGetData

// This routine takes a result descriptor, a reply descriptor and an error.
// If there is a result to add to the reply it makes sure the reply isn't
// NULL itself then adds the result to the reply depending on the error
// and the type of result.

OSErr	AddResultToReply(AEDesc* result, AEDesc* reply, OSErr error)
{
	OSErr	err;

		// Check that the reply is not NULL and there is a result to put in it  
	if (typeNull == reply->descriptorType || typeNull == result->descriptorType)
		return(error);
	
	if (noErr == error)
		err = AEPutParamDesc(reply, keyDirectObject, result);
	else
	{
		switch (result->descriptorType)
		{
			case typeInteger:
				err = AEPutParamDesc(reply, keyErrorNumber, result);
				break;
				
			case typeChar:
				err = AEPutParamDesc(reply, keyErrorString, result);
				break;
				
			default:
				err = errAETypeError;
		}
		
		if (noErr == err)
			err = error;		// Don't loose that error
	}

	return(err);
}


void SetPinValueAtIndex (int pinIndex, int value)
{
	UInt32 data;
	
	IOWarriorReadInterface0 (&data);
	
	if (value)
		data = data | (1 << bitOffsetForPinIndex(pinIndex));
	else
		data = data & ~(1 << bitOffsetForPinIndex(pinIndex));
		
	IOWarriorWriteInterface0 (&data);
}

int GetPinValueAtIndex (int pinIndex)
{
	UInt32 data;
	
	IOWarriorReadInterface0 (&data);
	
	if (data & (1 << bitOffsetForPinIndex(pinIndex)))
		return 1;
	else
		return 0;
}

// computes bit offset in report data from applescript pin index
int bitOffsetForPinIndex (int inIndex)
{
    int result = ((3 - (inIndex / 8)) * 8) + (inIndex % 8);

    return result;
}

// interrupt call back, invoked when interface 1 is sending reports
void myReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 /* inRefcon */)
{
	unsigned char* 	receivedData = (unsigned char*) inHIDReport;
	
	if (gSaveReports)
	{
		// add incoming report data 
		InsertReportData (receivedData, inHIDReportLength);
	}
}

// inserts received report data into the lists of reports received so far from interface 1
void InsertReportData (unsigned char* inData, UInt32 inReportLength)
{
	ReportListNode* newNode;
	
	// construct new node
	newNode = (ReportListNode*) NewPtr (sizeof (ReportListNode));
	newNode->reportData = NewPtr (inReportLength);
	newNode->nextNode = NULL;
	BlockMoveData (inData, newNode->reportData, inReportLength);
	
	// insert new node into list
	if (NULL == gReceivedReports)
	{
		gReceivedReports = newNode;
	}
	else
	{
		ReportListNode* currentNode = gReceivedReports;
		
		while (NULL != currentNode->nextNode)
		{
			currentNode = currentNode->nextNode;
		}
		currentNode->nextNode = newNode;
	}
}

// returns the number of reports in the list of received reports
int NumberOfReportsReceived ()
{
	if (NULL != gReceivedReports)
	{
		int 				result = 0;
		ReportListNode*		currentNode = gReceivedReports;
		
		while (NULL != currentNode->nextNode)
		{
			result++;
			currentNode = currentNode->nextNode;
		}
		return result;
	}
	return 0;
}

// returns the first (oldest) received report and removes it from the list of received reports
ReportListNode* ExtractFirstReport ()
{
	ReportListNode* result = gReceivedReports;

	if (NULL != gReceivedReports)
	{
		gReceivedReports = gReceivedReports->nextNode;
	}
	return result;
}

// frees up memory allocated to a reportlistnode
void DisposeReportListNode (ReportListNode* inNode)
{
	DisposePtr (inNode->reportData);
	DisposePtr ((Ptr) inNode);		
}