

#include "AEAccessors.h"
#include <AEObjects.h>

void InstallAEAccessor ()
{
	OSErr	err;

	
	err = AEInstallObjectAccessor(kTypePin, typeNull, NewOSLAccessorUPP (PinFromNullAccessor) , 0, false);
	err = AEInstallObjectAccessor(cProperty, kPrivateTypePin, NewOSLAccessorProc(PropertyFromPinAccessor), 0, false);
}

pascal OSErr PropertyFromPinAccessor(DescType			wantClass,
										const AEDesc	*container,
										DescType  		containerClass,
										DescType		form, 
										const AEDesc	*selectionData,
										AEDesc			*value,
										SInt32 			theRefCon)
{
	#pragma unused (theRefCon, containerClass)
	
	OSErr 		myErr = noErr;
	OSErr		ignoreErr;
	SInt32		pinIndex;
	Size    	actualSize;
	AEDesc  	pinDesc;
	AEDesc      propDesc;
	DescType	theProperty;
	PinPropToken pinProp;
	
	if ((wantClass != cProperty) ||
		  (form != formPropertyID))
	{
			return(errAEWrongDataType);
	}
	
	/* get the application token - it's the container */
	
	myErr = AECoerceDesc(container, kPrivateTypePin, &pinDesc);
	GetRawDataFromDescriptor(&pinDesc,
													 (Ptr)&pinIndex,
													 sizeof(pinIndex),
													 &actualSize);
													 
	/* get the property - it's in the selection data */
	
	myErr = AECoerceDesc(selectionData, typeType, &propDesc);
	GetRawDataFromDescriptor(&propDesc,
													 (Ptr)&theProperty,
													 sizeof(theProperty),
													 &actualSize);
													 
	/*
		Combine the two into single token
	*/
	pinProp.pinIndex = pinIndex;
	pinProp.pinProperty = theProperty;
	
	myErr = AECreateDesc(kPrivateTypePinProp,
											 (Ptr)&pinProp,
											 sizeof(pinProp),
											 value);
											 
	if (pinDesc.dataHandle)
		ignoreErr = AEDisposeDesc(&pinDesc);
	
	if (propDesc.dataHandle)
		ignoreErr = AEDisposeDesc(&propDesc);
		
	return myErr;

}

pascal OSErr PinFromNullAccessor(DescType			wantClass,
										const AEDesc	*container,
										DescType  		containerClass,
										DescType		form, 
										const AEDesc	*selectionData,
										AEDesc			*value,
										SInt32 			theRefCon)
{
#pragma unused (container,theRefCon, selectionData, value)

	OSErr       err;
	
		// Can only handle cWindow and cDocument
	if (wantClass != kTypePin)
		return(errAEWrongDataType);
		
		// Can only handle typeNull and typeMyAppl
	if (containerClass != typeNull /*&& containerClass != typeMyAppl */)
		return(errAENoSuchObject);
	
	switch (form)
	{
		case formAbsolutePosition:
			err = PinFormAbsolutePosition(selectionData, value);
			break;
			
			
		default:
			err = errAEBadTestKey;
	}
			
	return(err);
} // WindowFromNullAccessor

OSErr PinFormAbsolutePosition(const AEDesc *selectionData, AEDesc* result)
{
	AEDesc	itemDesc = {typeNull, NULL};
	short	pinCount,
			index;
	OSErr	err;

	pinCount = 32;
	
	if (typeAbsoluteOrdinal == selectionData->descriptorType)
	{
		switch (*(DescType *)*selectionData->dataHandle)
		{
			case kAEFirst:
				index = 1;
				break;
	
			case kAELast:
				index = pinCount;
				break;
	
			case kAEMiddle:
				index = (pinCount + 1) / 2;
				break;
	
			case kAEAny:
				index = (Random() % pinCount) + 1;
				break;
	
			case kAEAll:
				err = AECreateList(NULL, 0 , false, result);
				if (noErr != err) goto done;
				
				for (index = 1; index <= pinCount; index++)
				{
					err = GetDescOfNthPin(index, &itemDesc);
					if (noErr != err) goto done;
					
					err = AEPutDesc(result, 0, &itemDesc);
					if (noErr != err) goto done;
					
					if (itemDesc.dataHandle)
						AEDisposeDesc(&itemDesc);
				}
				
				goto done;		// We have created our list descriptor
				break;			// so we can just tidy up and return.
				
			default:
				err = errAETypeError;
		}
	}
	else
		err = GetIntegerFromDescriptor(selectionData, &index);

	if (noErr != err) goto done;
	
	if (index < 0)		// Handle negative indexes
		index = pinCount + index + 1;
		
	if (index > pinCount || index <= 0)
		err = errAEIllegalIndex;
	else
		err = GetDescOfNthPin(index, result);

done:	
	if (itemDesc.dataHandle)
		AEDisposeDesc(&itemDesc);

	return(err);
}

OSErr GetDescOfNthPin(short index, AEDesc* result)
{
	SInt32			descriptorData = index;
	OSErr			err = noErr;
	
	if (index <= 32)
		err = AECreateDesc(kPrivateTypePin, (Ptr)&descriptorData, sizeof(descriptorData), result);
	else
		err = errAEIllegalIndex;

	return(err);
}

OSErr	GetIntegerFromDescriptor(const AEDesc *sourceDesc, short *result)
{
  OSErr   myErr;
	OSErr   ignoreErr;
	Size    intSize;
	AEDesc  resultDesc;
	
	*result = 0;
	myErr  = AECoerceDesc(sourceDesc,typeShortInteger,&resultDesc);
	
	if (myErr==noErr) 
		{
			GetRawDataFromDescriptor(&resultDesc,
															 (Ptr)result,
															 2,
															 &intSize);
			if (intSize>2) 
				myErr = errAECoercionFail;
		}
	
	if (resultDesc.dataHandle) 
		ignoreErr = AEDisposeDesc(&resultDesc);
		
	return(myErr);
}
	
void	GetRawDataFromDescriptor(const AEDesc *theDesc,
																		 Ptr     destPtr,
																		 Size    destMaxSize,
																		 Size    *actSize)
  {
	  //Size copySize;


		if (theDesc->dataHandle) 
			{
				HLock((Handle)theDesc->dataHandle);
				*actSize = GetHandleSize((Handle)theDesc->dataHandle);
				
				if (destMaxSize < *actSize)
					*actSize = destMaxSize;
				
				BlockMove(*theDesc->dataHandle, destPtr, *actSize);
				
				HUnlock((Handle)theDesc->dataHandle);
			}
		else
			*actSize = 0;
	} /*GetRawDataFromDescriptor*/