library HIDinDLL;

uses
  Windows, Messages, SysUtils, Classes, Dialogs, Forms,
  DBT, JvHidControllerClass;

{$R *.res}

type
  // just an object to carry the methods
  TMethodObject = class(TObject)
  public
    procedure DLLDeviceChange(Sender: TObject);
    function EventPipe(var Msg: TMessage): Boolean;
  end;

var
  // the HID controller in a DLL
  HidCtl: TJvHidDeviceController;
  // an object to carry methods
  DLLHelperObject: TMethodObject;

// assigned to HidCtl.OnDeviceChange

procedure TMethodObject.DLLDeviceChange(Sender: TObject);
begin
  // just show that it works
  ShowMessage('DeviceChange happened');
end;

// this method is registered with Application.HookMainWindow and
// drives HidCtl externally

function TMethodObject.EventPipe(var Msg: TMessage): Boolean;
begin
  Result := False;
  // sort out WM_DEVICECHANGE : DBT_DEVNODES_CHANGED
  if (Msg.Msg = WM_DEVICECHANGE) and (TWMDeviceChange(Msg).Event = DBT_DEVNODES_CHANGED) then
    HidCtl.DeviceChange;
end;

procedure StartHID(hWnd: HWND); stdcall;
begin
  // assigns the Application object of the *DLL* a window to get messages from
  Application.Handle := hWnd;
  // create the HID controller
  HidCtl := TJvHidDeviceController.Create(nil);
  // create the helper object
  DLLHelperObject := TMethodObject.Create;
  // hook in the DLL
  Application.HookMainWindow(DLLHelperObject.EventPipe);
  // now the HID component works and can be used
  HidCtl.OnDeviceChange := DLLHelperObject.DLLDeviceChange;
end;

procedure StopHID; stdcall;
begin
  // clean up
  Application.UnhookMainWindow(DLLHelperObject.EventPipe);
  HidCtl.Free;
  DLLHelperObject.Free;
end;

exports
  StartHID,
  StopHID;

begin
end.
 