//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UsagesMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "JvHidControllerClass"
#pragma resource "*.dfm"
TUsagesForm *UsagesForm;
//---------------------------------------------------------------------------
__fastcall TUsagesForm::TUsagesForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TUsagesForm::HidCtlDeviceChange(TObject *Sender)
{
  TJvHidDevice *Dev;
  int I;

  // HidCtlDeviceChange happens before TUsagesForm.Create completed
  // DevListBox may have not been created yet
  if(DevListBox != NULL)
  {
    // hand back all the devices assigned to the list entries
    for(I = 0; I < DevListBox->Count; I++)
    {
      Dev = (TJvHidDevice *) DevListBox->Items->Objects[I];
      HidCtl->CheckIn(Dev);
      DevListBox->Items->Objects[I] = NULL;
    }
    DevListBox->Items->Clear();
    HidCtl->Enumerate();
  }
}
//---------------------------------------------------------------------------

bool __fastcall TUsagesForm::HidCtlEnumerate(TJvHidDevice *HidDev,
      const int Idx)
{
  TJvHidDevice *Dev;
  int N;
  AnsiString S;

  // add a descriptive entry to the listbox for the device
  if(HidDev->ProductName != NULL)
    N = DevListBox->Items->Add(HidDev->ProductName);
  else
    N = DevListBox->Items->Add(S.sprintf("Device VID=%04X PID=%04X",
      HidDev->Attributes.VendorID, HidDev->Attributes.ProductID));
  // check out the device and assign it to the list entry
  HidCtl->CheckOutByIndex(Dev, Idx);
  DevListBox->Items->Objects[N] = Dev;
  return(true);
}
//---------------------------------------------------------------------------

void __fastcall TUsagesForm::InfoClick(TObject *Sender)
{
  TInfoForm *InfoForm;

  // show info about the device assigned to the list entry
  if(DevListBox->Items->Count > 0 && DevListBox->ItemIndex >= 0)
  {
    InfoForm = new TInfoForm(this);
    InfoForm->Dev = (TJvHidDevice *) DevListBox->Items->Objects[DevListBox->ItemIndex];
    InfoForm->ShowModal();
    delete InfoForm;
  }
}
//---------------------------------------------------------------------------

void __fastcall TUsagesForm::FormShow(TObject *Sender)
{
  // this compensates the possibility that HidCtlDeviceChange
  // may not be able to fill the listbox the first time
  HidCtlDeviceChange(this);
}
//---------------------------------------------------------------------------

