unit KeyEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls,
  IOIRMain;

type
  TKeyEditForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Address: TLabel;
    Value: TLabel;
    Name: TEdit;
    Keys: TEdit;
    OK: TButton;
    Cancel: TButton;
    ExtKey: TCheckBox;
    procedure FormKeyDown(Sender: TObject;
      var Key: Word; Shift: TShiftState);
    procedure ExtKeyClick(Sender: TObject);
  public
    KeyData: TKeyData;
    ShiftValue: TShiftState;
    procedure ShowKeyName;
  end;

function KeyName(Key: Word; Extended: Boolean): string;

implementation

{$R *.dfm}

// translate virtual keycode into key description

function KeyName(Key: Word; Extended: Boolean): string;
var
  ScanCode: Word;
  Buffer: array [0..255] of Char;
begin
  // translate virtual keycode into scancode
  ScanCode := MapVirtualKey(Key, 0);
  if Extended then
    ScanCode := ScanCode + $100;
  // localized key description of scancode
  GetKeyNameText(ScanCode shl 16, Buffer, SizeOf(Buffer));
  Result := Buffer;
end;

procedure TKeyEditForm.ShowKeyName;
begin
  Keys.Text := KeyName(KeyData.Key, ExtKey.Checked);
  // add description of Shift, Alt, Ctrl
  if ssAlt in KeyData.Shift then
    Keys.Text := KeyName(VK_MENU, False) + '-' + Keys.Text;
  if ssCtrl in KeyData.Shift then
    Keys.Text := KeyName(VK_CONTROL, False) + '-' + Keys.Text;
  if ssShift in KeyData.Shift then
    Keys.Text := KeyName(VK_SHIFT, False) + '-' + Keys.Text;
end;

// Keys enthaelt die Tastenbeschreibung und
// wird bei jedem Tastendruck gesetzt

procedure TKeyEditForm.FormKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  // ignore Shift, Ctrl, Alt
  if (ActiveControl = Keys) and
   (Key <> VK_SHIFT) and (Key <> VK_CONTROL) and
   (Key <> VK_MENU) then
  begin
    // remember current key combination
    KeyData.Key   := Key;
    KeyData.Shift := Shift;
    ShowKeyName;
  end;
end;

// the extended bit is lost
// so it can be added back here
// the extended bit mainly distinguishes normal keys from
// their numpad key equivalents

procedure TKeyEditForm.ExtKeyClick(Sender: TObject);
begin
  KeyData.ExtendedKey := ExtKey.Checked;
  ShowKeyName;
end;

end.
