#ifndef	_IOW_DEVICE_
#define	_IOW_DEVICE_

#define	IOWKIT_DEVICE_COOKIE	'aWOI'

// last 8 values are buffered
#define	IOW_BUFFER_SIZE		8
// Determine buffer position
#define	IOWKIT_BUFFER_POS(pos)	((pos) & (IOW_BUFFER_SIZE-1))
// IOW KIT serial number string length
#define	IOWKIT_SN_LEN		8

typedef struct _IOWKIT_DEVICE_INTERNAL {
	// Cookie
	DWORD cookie;
	// Reference count
	ULONG refCount;
	// Is that main IOW handle?
	BOOLEAN isMain;
	// Is it legacy IOW device?
	BOOLEAN isLegacy;
	// IOW product ID
	USHORT productId;
	// Number of interfaces
	ULONG numPipes;
	// Open mode
	ULONG openMode;
	// I/O timeout
	ULONG ioTimeout;
	// Async I/O thread handle
	// currently it does only reads in async mode
	// to keep up 32-bits value in sync with IOW
	HANDLE ioThread;
	// Read complete event
	HANDLE readEvent;
	// Read complete 1 event
	HANDLE readEvent1;
	// Terminate event
	HANDLE endEvent;
	// Thread has been terminated event
	HANDLE threadTermEvent;
	// Window handle and message
	HWND callbackWnd;
	UINT callbackMsg;
	// Mutex protecting buffer from changing
	HANDLE bufMutex;
	// Last value read from device
	DWORD buffer[IOW_BUFFER_SIZE];
	// Start & end buffer positions
	DWORD bufStart, bufEnd;
	// Number of buffers used
	DWORD numBuf;
	// Last value read from IO endpoint
	DWORD lastValue;
	// Have we read anything?
	BOOLEAN readAny;
	// All pipes are here
	HANDLE iowHandle[IOWKIT_MAX_PIPES];
	// Serial number string
	WCHAR serialNumber[IOWKIT_SN_LEN + 1];
} IOWKIT_DEVICE_INTERNAL, *PIOWKIT_DEVICE_INTERNAL;

// HID function pointers
extern BOOLEAN 
(__stdcall *pHidD_GetAttributes)(
    IN  HANDLE              HidDeviceObject,
    OUT PHIDD_ATTRIBUTES    Attributes);

extern void
(__stdcall *pHidD_GetHidGuid)(LPGUID HidGuid);

extern BOOLEAN (__stdcall *pHidD_GetPreparsedData)(HANDLE dev, PHIDP_PREPARSED_DATA *prepData);

extern NTSTATUS (__stdcall *pHidP_GetCaps)(PHIDP_PREPARSED_DATA prepData, PHIDP_CAPS caps);

extern BOOLEAN (__stdcall *pHidD_FreePreparsedData)(PHIDP_PREPARSED_DATA prepData);

extern BOOLEAN (__stdcall *pHidD_GetNumInputBuffers)(HANDLE HidDeviceObject, PULONG NumberBuffers);

extern BOOLEAN (__stdcall *pHidD_SetNumInputBuffers)(HANDLE HidDeviceObject, ULONG NumberBuffers);

extern BOOLEAN (__stdcall *pHidD_GetSerialNumberString)(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength);

// iowkit.cpp internal data
extern ULONG iowNumDevices;
extern IOWKIT_DEVICE_INTERNAL iowHandles[];
extern ULONG iowLegacyOpenMode;

// iowkit.cpp internal functions
BOOLEAN
IowKitLoadHid(VOID);

VOID
IowKitUnloadHid(VOID);

// readwrit.cpp internal functions
HANDLE
IowKitGetPipeHandle(IOWKIT_HANDLE devHandle, ULONG numPipe);

//
BOOLEAN
IowKitGetSerial(HANDLE pipeHandle, PCHAR buffer, ULONG bufLen);

PIOWKIT_DEVICE_INTERNAL
IowKitFindByNumberOrSerial(ULONG iowNum, PCHAR serialNumber, BOOLEAN alloc);

VOID __stdcall
IowDummyCompletion(DWORD dummy1, DWORD dummy2, OVERLAPPED *dummy3);

DWORD __stdcall
IowKitReadThread(PIOWKIT_DEVICE_INTERNAL iowHandle);

BOOLEAN
IowKitFireUpThread(PIOWKIT_DEVICE_INTERNAL iowHandle);

BOOLEAN
IowKitInsertBuffer(PIOWKIT_DEVICE_INTERNAL iowDev, DWORD value);

VOID
IowKitGetBuffer(PIOWKIT_DEVICE_INTERNAL iowDev, DWORD *value);

// async.cpp internal functions
VOID
IowKitProcessCallbacks(PIOWKIT_DEVICE_INTERNAL iowDev);

#endif
