VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "IO-Warrior sample application"
   ClientHeight    =   2160
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4455
   LinkTopic       =   "Form1"
   ScaleHeight     =   2160
   ScaleWidth      =   4455
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton RandomAllButton 
      Caption         =   "Random blink all"
      Height          =   495
      Left            =   3360
      TabIndex        =   10
      Top             =   1560
      Width           =   975
   End
   Begin VB.TextBox TextVal4 
      Height          =   375
      Left            =   1560
      TabIndex        =   3
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal3 
      Height          =   375
      Left            =   1080
      TabIndex        =   2
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.TextBox TextVal2 
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.CommandButton ReadButton 
      Caption         =   "Read value"
      Height          =   495
      Left            =   120
      TabIndex        =   4
      Top             =   1560
      Width           =   975
   End
   Begin VB.CommandButton RandomButton 
      Caption         =   "Random blinks"
      Height          =   495
      Left            =   2280
      TabIndex        =   7
      Top             =   1560
      Width           =   975
   End
   Begin VB.TextBox TextVal1 
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Text            =   "0"
      Top             =   720
      Width           =   375
   End
   Begin VB.CommandButton WriteButton 
      Caption         =   "Write value"
      Height          =   495
      Left            =   1200
      TabIndex        =   6
      Top             =   1560
      Width           =   975
   End
   Begin VB.Label Label2 
      Caption         =   "1st       2nd     3rd     4th"
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   360
      Width           =   1695
   End
   Begin VB.Label ReadLabel 
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1200
      Width           =   2655
   End
   Begin VB.Label Label1 
      Caption         =   "Bytes to write"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   120
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This is Basic IO-Warrior usage sample
' This sample shows how to program IO-Warrior for input and output
' and how to use multiple devices

' IO-Warrior handles
Dim iowHandles(16) As Long
' Number of IOWs
Dim numIows As Long
' Data buffer
' Basic data buffer is 5 bytes long: 1 byte for report id, 4 bytes for data
Dim data(4) As Byte

' Perform random blinks
Private Sub RandomBlinks(numBlink As Long)
' Number of bytes written
Dim nWritten As Long
' Loop variable
Dim I As Long
Dim J As Long
' LEDs value
Dim Value As Byte
    ' Set up Report ID
    ' Report ID 0 is for writing to zero interface (32 IO-Warrior I/O pins)
    data(0) = 0
    ' Set up 3 low bytes
    data(1) = &HFF
    data(2) = &HFF
    data(3) = &HFF
    ReadLabel.Caption = "Random blinks..."
    ReadLabel.Refresh
    ' Loop writing random data and blinking LEDs
    For I = 0 To 200
        ' Make 8 bit random value
        ' if bit is 0 - LED will be on
        ' if bit is 1 - LED will be off
        For J = 1 To numBlink
            Value = Int((10 * Rnd)) And 1
            Value = Value Or ((Int((10 * Rnd)) And 1) * 2)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 4)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 8)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 16)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 32)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 64)
            Value = Value Or ((Int((10 * Rnd)) And 1) * 128)
            ' Fourth byte is controlling standard LEDs
            data(4) = Value
            ' Write to IOW
            nWritten = IowKitWrite(iowHandles(J - 1), 0, data(0), 5)
        Next J
    Next I
    For J = 1 To numBlink
    ' Turn off all LEDs
    data(4) = &HFF
    ' Write to IO-Warrior
    nWritten = IowKitWrite(iowHandles(J - 1), 0, data(0), 5)
    Next J
    ReadLabel.Caption = "Random blinks complete"
End Sub

' Blink all IOWs
Private Sub RandomAllButton_Click()
    Call RandomBlinks(numIows)
End Sub

Private Sub RandomButton_Click()
    ' Perform random blinks
    Call RandomBlinks(1)
End Sub

Private Sub Form_Load()
Dim I As Long
    ' Initialize everything
    ' Open device
    iowHandles(0) = IowKitOpenDevice()
    ' Fail if can't open
    If (iowHandles(0) = 0) Then
        ' Barf and exit from program
        MsgBox "Can not open device!", 0, "Error"
        End
    End If
    ' Get number of IO-Warrior devices in system
    numIows = IowKitGetNumDevs()
    ' Get all IO-Warrior handles
    For I = 2 To numIows
        iowHandles(I - 1) = IowKitGetDeviceHandle(I)
    Next I
End Sub

Private Sub Form_Unload(Cancel As Integer)
Dim I As Long
    ' Close all IO-Warrior devices
    For I = 1 To numIows
        ' Close IO-Warrior device
        IowKitCloseDevice (iowHandles(I - 1))
    Next I
End Sub

' Read something from IO-Warrior
Private Sub ReadButton_Click()
Dim Res As Long
    ' Perform a read
    ' Don't forget that we read report ID too
    ' So we have 5 bytes buffer
    ' Turn off all LEDs
    ' Unmask all input lines
    ' first byte is report ID
    data(0) = &O0
    ' first report byte
    data(1) = &HFF
    ' second report byte
    data(2) = &HFF
    ' third report byte
    data(3) = &HFF
    ' fourth report byte
    data(4) = &HFF
    ' Write to IO-Warrior
    nWritten = IowKitWrite(iowHandles(0), 0, data(0), 5)
    ' Handle error
    If (nWritten <> 5) Then
        ' You can use GetLastError() to get error code
        MsgBox "Can not set input mask!", 0, "Error"
        Exit Sub
    End If
    ' After this write, all input lines are unmasked
    ' Set caption
    ReadLabel.Caption = "Reading from IOW"
    ReadLabel.Refresh
    ' Read from IO-Warrior
    Res = IowKitRead(iowHandles(0), 0, data(0), 5)
    ' Check results
    If (Res <> 5) Then
        ReadLabel.Caption = "Read from IOW wrong?"
    Else
        ' Convert and set data
        TextVal1.Text = Hex$(data(1))
        TextVal2.Text = Hex$(data(2))
        TextVal3.Text = Hex$(data(3))
        TextVal4.Text = Hex$(data(4))
        ReadLabel.Caption = "Read from IOW complete"
    End If
End Sub

' Write value
Private Sub WriteButton_Click()
Dim Value As Byte
    ' Report ID 0
    data(0) = 0
    ' Get values from text
    ' Note: we don't check values here
    ' so you'd better enter correct values
    Value = Val("&H" & TextVal1.Text)
    ' Set first report byte
    data(1) = Value
    Value = Val("&H" & TextVal2.Text)
    ' Set second report byte
    data(2) = Value
    Value = Val("&H" & TextVal3.Text)
    ' Set third report byte
    data(3) = Value
    Value = Val("&H" & TextVal4.Text)
    ' Set fourth report byte
    data(4) = Value
    ' Write to IOW
    Res = IowKitWrite(iowHandles(0), 0, data(0), 5)
    ' Handle error
    If (Res <> 5) Then
        ' You can get error code from GetLastError()
        MsgBox "Write to IOW failed!", 0, "Error"
    End If
End Sub
