#include <stdio.h>
#include <Events.h>

#include "IOWarriorOS9Lib.h"

void wait (int Seconds);

int main(void)
{
	int	data;
	int i,
		j;
	int	err;
	int	iterations = 0;
	
	IOWarriorInit ();
	
	while (iterations++ < 10)
	{
		data = 255;
		err = IOWarriorWriteInterface0 (&data);
		if (err)
		{
			printf ("IOWarriorWriteInterface0 failed\n");
		}
		data = 0;
		err = IOWarriorReadInterface0 (&data);
		if (err)
		{
			printf ("IOWarriorReadInterface0 failed\n");
		}
		else
		{
			printf ("IOWarriorReadInterface0 read data %d\n", data);
		}
		
		for (i = 0; i < 2; i++)
		{
			data = 1;
			for (j = 0; j < 7; j++)
			{
				data = (data << 1);
				err = IOWarriorWriteInterface0 (&data);
				if (err)
				{
					printf ("IOWarriorWriteInterface0 failed\n");
				}
			}
		}
		data = 0;
		IOWarriorWriteInterface0 (&data);
		if (err)
		{
			printf ("IOWarriorWriteInterface0 failed\n");
		}
		data = 64;
		IOWarriorWriteInterface0 (&data);
		if (err)
		{
			printf ("IOWarriorWriteInterface0 failed\n");
		}
		wait (1);
	}
}

void wait (int inSeconds)
{
	int limit;
	
	limit = TickCount () + (inSeconds * 60);
	
	while (TickCount () < limit)
	{
		;
	}
}