//
// ioblink.cpp - Blinking LEDs sample
//

#include "stdafx.h"
#include "iowclass.h"

int main(int argc, char* argv[])
{
	IOWarrior iow;
	IOWarrior iows[IOWKIT_MAX_DEVICES];
	int i, j, bits;
	ULONG numIows;
	IOWKIT_REPORT rep;
	WCHAR sn[9];
	BOOLEAN rc;

	// Open device
	if (!iow.Open()) {
		printf("Failed to open device\n");
		goto out;
	}
	// Get number of IOWs in system
	numIows = IowKitGetNumDevs();
	printf("%d IOWs in system\n", numIows);
	// Get all IOW handles
	for (i = 0; i < numIows; i++) {
		// Get device handle and init object
		iows[i] = IowKitGetDeviceHandle(i + 1);
		// Get serial number
		iows[i].GetSerialNumber(sn);
		printf("%d IOW, PID %x, S/N \"%ws\"\n", i+1, iows[i].GetProductId(),
			&sn);
		rc = iows[i].ReadImmediate((ULONG *) &bits);
		printf("ReadImm(): rc %d bits %x\n", rc, bits);
	}
	// Init report
	// Report ID 0 is for writing to 32 input/output pins
	rep.ReportID = 0;
	printf("Blinking LEDs...\n");
	// Blinking'
	for (i = 0; i < 100; i++) {
		// Make every IOW blink
		for (j = 0; j < numIows; j++) {
			// Generate random 8 bits
			bits = (rand() & 1) << 7;
			bits |= (rand() & 1) << 6;
			bits |= (rand() & 1) << 5;
			bits |= (rand() & 1) << 4;
			bits |= (rand() & 1) << 3;
			bits |= (rand() & 1) << 2;
			bits |= (rand() & 1) << 1;
			bits |= (rand() & 1);
			// Shift them to high 32 bits
			bits <<= 24;
			// Write to simple endpoint
			rc = iows[j].WriteSimple(bits);
			// Check for error
			if (!rc) {
				printf("Can\'t write, err %d\n", GetLastError());
			}
		}
		// Sleep for 25ms
		Sleep(25);
	}
	printf("Blinking complete\n");
	// Set LEDs off
	for (i = 0; i < numIows; i++) {
		// Write to simple endpoint
		iows[i].WriteSimple(~0UL);
		iows[i].WriteSimple(~0UL);
	}
	// Read immediate
	rc = iow.ReadImmediate((ULONG *) &bits);
	printf("ReadImm(): rc %d bits %x\n", rc, bits);
	// Close device
	iow.Close();
out:

	return 0;
}
