//
// IO-Warrior SDK library
//
#include "stdafx.h"
#include "iowkit.h"
#include "iowdev.h"
#include "debug.h"

#pragma	pack(1)

//#define	DUMMY_DEBUG

BOOL APIENTRY
DllMain(HANDLE hModule,
	DWORD  ul_reason_for_call,
	LPVOID lpReserved)
{
	switch (ul_reason_for_call) {
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}

	// We always succeed
	return TRUE;
}

//#if	IOW_DBG
// IOW Kit functions
extern "C" {
__declspec(dllexport) ULONG IowKitDebugLevel = 0;
}
//#endif

// HID stuff
// HID.DLL library handle
HMODULE hHid = NULL;

// Legacy open mode
ULONG iowLegacyOpenMode = IOW_OPEN_SIMPLE;

// HID function pointers
BOOLEAN 
(__stdcall *pHidD_GetAttributes)(
    IN  HANDLE              HidDeviceObject,
    OUT PHIDD_ATTRIBUTES    Attributes);

void
(__stdcall *pHidD_GetHidGuid)(LPGUID HidGuid);

BOOLEAN (__stdcall *pHidD_GetPreparsedData)(HANDLE dev, PHIDP_PREPARSED_DATA *prepData);

NTSTATUS (__stdcall *pHidP_GetCaps)(PHIDP_PREPARSED_DATA prepData, PHIDP_CAPS caps);

BOOLEAN (__stdcall *pHidD_FreePreparsedData)(PHIDP_PREPARSED_DATA prepData);

BOOLEAN (__stdcall *pHidD_GetNumInputBuffers)(HANDLE HidDeviceObject, PULONG NumberBuffers);

BOOLEAN (__stdcall *pHidD_SetNumInputBuffers)(HANDLE HidDeviceObject, ULONG NumberBuffers);

BOOLEAN (__stdcall *pHidD_GetSerialNumberString)(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength);

// HID stuff
// Load HID.DLL library and lookup needed functions
BOOLEAN
IowKitLoadHid(VOID)
{
	// Load HID.DLL
	hHid = LoadLibrary("hid.dll");
	// Fail if there is no HID.DLL lib
	if (hHid == NULL) {
		return FALSE;
	}
	// Look up all needed functions
	pHidD_GetAttributes = (BOOLEAN (__stdcall *)(HANDLE, PHIDD_ATTRIBUTES)) GetProcAddress(hHid, "HidD_GetAttributes");
	pHidD_GetHidGuid = (void (__stdcall *)(LPGUID)) GetProcAddress(hHid, "HidD_GetHidGuid");
	pHidD_GetPreparsedData = (BOOLEAN (__stdcall *)(HANDLE, PHIDP_PREPARSED_DATA *)) GetProcAddress(hHid, "HidD_GetPreparsedData");
	pHidP_GetCaps = (DWORD (__stdcall *)(PHIDP_PREPARSED_DATA, PHIDP_CAPS)) GetProcAddress(hHid, "HidP_GetCaps");
	pHidD_FreePreparsedData = (BOOLEAN (__stdcall *)(PHIDP_PREPARSED_DATA)) GetProcAddress(hHid, "HidD_FreePreparsedData");
	pHidD_GetNumInputBuffers = (BOOLEAN (__stdcall *)(HANDLE, PULONG)) GetProcAddress(hHid, "HidD_GetNumInputBuffers");
	pHidD_SetNumInputBuffers = (BOOLEAN (__stdcall *)(HANDLE, ULONG)) GetProcAddress(hHid, "HidD_SetNumInputBuffers");
	pHidD_GetSerialNumberString = (BOOLEAN (__stdcall *)(HANDLE, PVOID, ULONG)) GetProcAddress(hHid, "HidD_GetSerialNumberString");
	// Fail if we can't look up these functions
	if (!pHidD_GetAttributes || !pHidD_GetHidGuid || !pHidD_GetSerialNumberString) {
			IowKitUnloadHid();

			return FALSE;
	}
	if (!pHidD_GetPreparsedData || !pHidP_GetCaps || !pHidD_FreePreparsedData || !pHidD_SetNumInputBuffers) {
			IowKitUnloadHid();

			return FALSE;
	}
	if (!pHidD_GetNumInputBuffers) {
			IowKitUnloadHid();

			return FALSE;
	}

	// OK, we loaded it
	return TRUE;
}

// Unload HID.DLL
VOID
IowKitUnloadHid(VOID)
{
	// Unload HID.DLL
	if (hHid) {
		FreeModule(hHid);
	}
	// Zero function pointers
	pHidD_GetAttributes = NULL;
	pHidD_GetHidGuid = NULL;
	pHidD_GetPreparsedData = NULL;
	pHidP_GetCaps = NULL;
	pHidD_FreePreparsedData = NULL;
	hHid = NULL;
}
