//
// iowclass.h
// IO-Warrior SDK library
//
// IO-Warrior SDK wrapper class
//

#ifndef	_IOWCLASS_H_
#define	_IOWCLASS_H_

class IOWarrior {
	private:
	IOWKIT_HANDLE m_devHandle;
	USHORT m_productId;
	BOOLEAN m_childDevice;
	public:
	// Constructor
	IOWarrior(void) { m_devHandle = NULL; m_childDevice = FALSE; m_productId = 0; }
	// Destructor
	~IOWarrior() { Close(); }

	// Set legacy open mode
	BOOLEAN SetLegacyOpenMode(ULONG openMode)
	{
		BOOLEAN rc;

		rc = IowKitSetLegacyOpenMode(openMode);

		return rc;
	}

	// Open IO-Warrior devices
	BOOLEAN Open(void)
	{
		// Don't open it twice!
		if (m_devHandle != NULL) {
			return FALSE;
		}
		// Open IOWs
		m_devHandle = IowKitOpenDevice();

		// Return result
		return (m_devHandle != NULL);
	}

	// Close IO-Warrior devices
	void Close(void)
	{
		// Don't close if it's not open!
		if (m_devHandle == NULL) {
			return;
		}
		// Don't close if it's child device
		if (IsChildDevice()) {
			return;
		}
		// Close IOW
		IowKitCloseDevice(m_devHandle);
		// Invalidate handle
		m_devHandle = NULL;
	}

	// Set device handle (for child devices)
	void SetHandle(IOWKIT_HANDLE devHandle)
	{
		m_devHandle = devHandle;
		m_childDevice = TRUE;
	}

	// Get device handle
	IOWKIT_HANDLE GetHandle(void)
	{
		return m_devHandle;
	}

	// Now you can simply use iowobj = devHandle;
	IOWarrior& operator = (IOWKIT_HANDLE iowHandle)
	{
		SetHandle(iowHandle);

		return *this;
	}

	// Is that child device?
	BOOLEAN IsChildDevice(void)
	{
		return m_childDevice;
	}

	USHORT GetProductId(void)
	{
		USHORT res;

		// Check if we have already got product ID
		if (m_productId) {
			return m_productId;
		}
		// Get and save product ID
		res = m_productId = IowKitGetProductId(m_devHandle);

		return res;
	}

	BOOLEAN GetSerialNumber(PWCHAR buffer)
	{
		BOOLEAN rc;

		rc = IowKitGetSerialNumber(m_devHandle, buffer);

		return rc;
	}

	// Read from IOW
	ULONG Read(ULONG numPipe, PCHAR buffer, ULONG nbytes)
	{
		ULONG res;

		res = IowKitRead(m_devHandle, numPipe, buffer, nbytes);

		return res;
	}

	// Write to IOW
	ULONG Write(ULONG numPipe, PCHAR buffer, ULONG nbytes)
	{
		ULONG res;

		res = IowKitWrite(m_devHandle, numPipe, buffer, nbytes);

		return res;
	}

	// Read immediate
	BOOLEAN ReadImmediate(PDWORD buffer)
	{
		BOOLEAN rc;

		rc = IowKitReadImmediate(m_devHandle, buffer);

		return rc;
	}

	// Write simple value
	BOOLEAN WriteSimple(DWORD value)
	{
		IOWKIT_REPORT rep;
		BOOLEAN rc = FALSE;

		// Init report
		rep.ReportID = 0;
		rep.Value = value;
		switch (GetProductId()) {
		// Write simple value to IOW40
		case 0x1500:
		rc = Write(0, (PCHAR) &rep, 5);
		break;
		// Write simple value to IOW24
		case 0x1501:
		rc = Write(0, (PCHAR) &rep, 3);
		break;
		}

		return rc;
	}

	// Set I/O timeout
	BOOLEAN SetTimeout(ULONG timeout)
	{
		return IowKitSetTimeout(m_devHandle, timeout);
	}
};

#endif
