Attribute VB_Name = "iow"

' Required kernel32 functions
Public Declare Function GetLastError _
    Lib "kernel32" () _
As Long

' IO-Warrior low-level library API functions
' IOW SDK V1.2 beta

' Open IO-Warrior device
' This functions returns handle to IOW device
' and 0 if IO-Warrior is not found
Public Declare Function IowKitOpenDevice _
    Lib "iowkit" () _
As Long

' This functions closes IO-Warrior device
Public Declare Sub IowKitCloseDevice _
    Lib "iowkit" _
    (ByVal iowHandle As Long)

' Perform write to IO-Warrior
' Parameters:
' IowHandle - handle returned by IowKitOpenDevice()
' numPipe - Number of interface to write to (ranges from 1 to number
' of interfaces in your IO-Warrior, see docs coming with it to know how many
' interfaces it has)
' buffer - Data to write
' length - how many bytes to write
' Returns: Number of bytes written and zero if error occured
Public Declare Function IowKitWrite _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long, _
     ByRef buffer As Byte, _
     ByVal length As Long _
    ) _
As Long

' Perform read from IO-Warrior
' Parameters:
' IowHandle - handle returned by IowKitOpenDevice()
' numPipe - Number of interface to write to (ranges from 1 to number
' of interfaces in your IO-Warrior, see docs coming with it to know how many
' interfaces it has)
' buffer - Buffer to read
' length - how many bytes to read
' Returns: Number of bytes read and zero if error occured
Public Declare Function IowKitRead _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByVal numPipe As Long, _
     ByRef buffer As Byte, _
     ByVal length As Long _
    ) _
As Long

Public Declare Function IowKitReadImmediate _
    Lib "iowkit" _
    (ByVal iowHandle As Long, _
     ByRef buffer As Long) _
As Long

' Get number of IOW devices
Public Declare Function IowKitGetNumDevs _
    Lib "iowkit" () _
As Long

' Get Nth IOW device handle
Public Declare Function IowKitGetDeviceHandle _
    Lib "iowkit" _
    (ByVal numDevice As Long) _
As Long

Public Declare Function IowKitSetLegacyOpenMode _
    Lib "iowkit" _
    (ByVal openMode As Long) _
As Long

Public Declare Function IowKitGetProductId _
    Lib "iowkit" _
    () _
As Long

Public Declare Function IowKitGetSerialNumber _
    Lib "iowkit" _
    (ByVal iowHandle As Long, ByRef buffer As String) _
As Long

Public Declare Function IowKitSetTimeout _
    Lib "iowkit" _
    (ByVal iowHandle As Long, ByVal TimeOut As Long) _
As Long
