/*
 *  Copyright  1997-2002 Metrowerks Corporation.  All Rights Reserved.
 *
 *  Questions and comments to:
 *       <mailto:support@metrowerks.com>
 *       <http://www.metrowerks.com/>
 */

#include <stdio.h>
#include <string.h>
#include "IOWarriorOS9Lib.h"
#include <Events.h>


void bzero (void* buffer, int length) ;
void testReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 inRefcon);
void wait (int Seconds);


void wait (int inSeconds)
{
	int limit;
	
	limit = TickCount () + (inSeconds * 60);
	
	while (TickCount () < limit)
	{
		;
	}
}

int main(void)
{
	unsigned char 	buffer[7];
	OSErr			err;
	
	printf ("Initializing IOWarrior library functions\n");
	IOWarriorInit ();
	IOWarriorSetAutoCloseInterfaces (0);
	printf("Enabling LDC Mode\n");
	bzero (buffer, 7);
	buffer[0] = 0x01;
	err = IOWarriorWriteInterface1 (4, buffer);
	printf("Initialzing display\n");
	bzero (buffer, 7);
	buffer[0] = 0x03;
	buffer[1] = 0x38;
	buffer[2] = 0x01;
	buffer[3] = 0x0F;
	err = IOWarriorWriteInterface1 (5, buffer);
	printf("Writing 'Test' to the display\n");
	bzero (buffer, 7);
	buffer[0] = 0x84;
	buffer[1] = 0x54;
	buffer[2] = 0x65;
	buffer[3] = 0x73;
	buffer[4] = 0x74;
	err = IOWarriorWriteInterface1 (5, buffer);
	printf("Moving dislpay pointer to first position\n");
	bzero (buffer, 7);
	buffer[0] = 0x01;
	buffer[1] = 0x80;
	err = IOWarriorWriteInterface1 (5, buffer);
	printf ("Setting report handler for incoming reports\n");
	err = IOWarriorInstallReportHandlerInterface1 ( testReportHandler, 0);
	if (err)
	{
		printf ("Received error %d while trying to install report handler\n", err);
	}
	printf("Sending read command for first 4 bytes\n");
	bzero (buffer, 7);
	buffer[0] = 0x84;
	err = IOWarriorWriteInterface1 (6, buffer);
	
	wait (2);
	
	IOWarriorCloseAllInterfaces ();
		
	return 0;
}

// If anyone knows where metrowerks hides bzero ... 
void bzero (void* buffer, int length) 
{
	memset(buffer, 0, length);
}

// incoming reports from interface 0 should end up here
void testReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 /* inRefcon */)
{
	char* 	receivedData = (char*) inHIDReport;
	int 	i;
	
	printf ("Received report of size %ld\n", inHIDReportLength);
	for (i = 0; i < inHIDReportLength; i++)
	{
		printf ("data[%d] = %d\n", i, receivedData[i]);
	}
}