#include <stdio.h>
#include <Events.h>
#include <string.h>
#include <SegLoad.h>

#include "IOWarriorOS9Lib.h"

void wait (int Seconds);
void testReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 /* inRefcon */);
void bzero (void* buffer, int length) ;

int main(void)
{
	char buffer[2];
	IOWarriorListNode*	node;
	OSErr				err = noErr;
	
	buffer[0] = 0x0;
	buffer[1] = 0x0;
	
	IOWarriorInit ();
	
	node = IOWarriorFirstInterfaceNodeOfType (kIOWarrior24Interface0);
	if (node)
	{
		err = IOWarriorWrite (node, 0, 2, buffer);
	}
	node = IOWarriorFirstInterfaceNodeOfType (kIOWarrior24Interface1);
	if (node)
	{
		char params[8];
            
     	printf ("Installing report handler for incoming reports\n");

       	bzero (params, 8);
        params[0] = 0x0C;
        params[1] = 0x01;
		err = IOWarriorInstallReportHandlerForInterfaceAtNode ( node,testReportHandler , 0);
		IOWarriorSetAutoCloseInterfaces (false); // interface has to stay open in order to receive interrupt reports
		if (err)
		{	
			printf ("Received error %d while trying to install report handler\n", err);
		}
		IOWarriorWrite (node, 0, 8, params);
		printf ("5 seconds to receive IR commands ... ");
		wait (5);
	}
	
	return 0;
	
}

// incoming reports from interface 1 should end up here
void testReportHandler (void * inHIDReport, UInt32 inHIDReportLength, UInt32 /* inRefcon */)
{
	char* 	receivedData = (char*) inHIDReport;
	int 	i;
	
	printf ("Received report of size %ld\n", inHIDReportLength);
	for (i = 0; i < inHIDReportLength; i++)
	{
		printf ("data[%d] = %d\n", i, receivedData[i]);
	}
}

// If anyone knows where metrowerks hides bzero ... 
void bzero (void* buffer, int length) 
{
	memset(buffer, 0, length);
}

void wait (int inSeconds)
{
	int limit;
	
	limit = TickCount () + (inSeconds * 60);
	
	while (TickCount () < limit)
	{
		;
	}
}
